#include "General.h"

DynamicVectorClass<StringClass> Settings::AutoAnnounceList;
bool Settings::EnablePageSound, Settings::EnableAFKDetector, Settings::PageAFKPlayers, 
	Settings::EnableAuthProtect, Settings::EnableEndGameRecs, Settings::IsMarathon;
StringClass Settings::PageSoundFile, Settings::BotAcronym, Settings::BotName, 
	Settings::MapRules, Settings::PageColour, Settings::IRCHost, Settings::IRCHostBackup,
	Settings::NickServPass, Settings::IRCNick, Settings::IRCNickBackup, Settings::IRCPublicChan,
	Settings::IRCAdminChan, Settings::IRCAdminKey, Settings::Rules;
int Settings::LimitNameLength, Settings::AutoAnnounceInterval, Settings::IRCPort, Settings::IRCPortBackup,
	Settings::AuthProtectInterval;
time_t Settings::StartTime;

HashTemplateClass<StringClass, Moderator_t*> Settings::ModsGameNick, Settings::ModsIRCNick;

void Settings::Load()
{
	Settings::StartTime = time(NULL);

	EnablePageSound = Settings::Load_Bool(ABDIR "Settings.ini", "General", "EnablePageSound");
	PageSoundFile = Settings::Load_String(ABDIR "Settings.ini", "General", "PageSoundFile");
	EnableAFKDetector = Settings::Load_Bool(ABDIR "AFKDetector.ini", "General", "EnableAFKDetector");
	PageAFKPlayers = Settings::Load_Bool(ABDIR "AFKDetector.ini", "General", "PageAFKPlayers");
	BotName = Settings::Load_String(ABDIR "Settings.ini", "General", "BotName");
	BotAcronym = Settings::Load_String(ABDIR "Settings.ini", "General", "BotAcronym");
	LimitNameLength = Settings::Load_Int(ABDIR "Settings.ini", "General", "LimitNameLength");
	EnableEndGameRecs = Settings::Load_Bool(ABDIR "Settings.ini", "General", "EnableEndGameRecs");
	AutoAnnounceInterval = Settings::Load_Int(ABDIR "AutoAnnounce.ini", "General", "AutoAnnounceInterval");
	AutoAnnounceList = Settings::Load_String_List(ABDIR "AutoAnnounce.ini", "StringsList");
	EnableAuthProtect = Settings::Load_Bool(ABDIR "Settings.ini", "General", "EnableAuthProtect");
	PageColour = Settings::Load_String(ABDIR "Settings.ini", "General", "PageColour");
	AuthProtectInterval = Settings::Load_Int(ABDIR "Settings.ini", "General", "AuthProtectInterval");
	IsMarathon = Settings::Load_Bool(ABDIR "Settings.ini", "General", "IsMarathon");
	Rules = Load_String(ABDIR "Settings.ini", "General", "Rules");

	IRCHost = Settings::Load_String(ABDIR "IRC.ini", "General", "IRCHost");
	IRCHostBackup = Settings::Load_String(ABDIR "IRC.ini", "General", "IRCHostBackup");
	NickServPass = Settings::Load_String(ABDIR "IRC.ini", "General", "NickServPass");
	IRCNick = Settings::Load_String(ABDIR "IRC.ini", "General", "IRCNick");
	IRCNickBackup = Settings::Load_String(ABDIR "IRC.ini", "General", "IRCNickBackup");
	IRCPublicChan = Settings::Load_String(ABDIR "IRC.ini", "General", "IRCPublicChan");
	IRCAdminChan = Settings::Load_String(ABDIR "IRC.ini", "General", "IRCAdminChan");
//	IRCAdminKey = Settings::Load_String(ABDIR "IRC.ini", "General", "IRCAdminKey");
	IRCPort = Settings::Load_Int(ABDIR "IRC.ini", "General", "IRCPort");
	IRCPortBackup = Settings::Load_Int(ABDIR "IRC.ini", "General", "IRCPortBackup");

	Settings::Load_Moderators();
}

void Settings::Unload()
{
}

StringClass Settings::Load_String(const char* Ini, const char* Section, const char* Entry)
{
	StringClass Result;
	INIClass *Ini2 = Settings::Open_INI(Ini);
	
	Ini2->Get_String(Result, Section, Entry, "ERR");
	Ini2->Shutdown();

	if (Result == "ERR")
	{
		Functions::Show_Fatal_Warning(TT_FORMAT(256, "Error loading variable %s from section %s in %s",
			Entry, Section, Ini));
	}
	return Result;
}

int Settings::Load_Int(const char* Ini, const char* Section, const char* Entry)
{
	int Result;

	INIClass *Ini2 = Settings::Open_INI(Ini);

	Result = Ini2->Get_Int(Section, Entry, -1337);
	Ini2->Shutdown();

	if (Result == -1337)
	{
		Functions::Show_Fatal_Warning(TT_FORMAT(256, "Error loading variable %s from section %s in %s",
			Entry, Section, Ini));
	}
	return Result;
}

float Settings::Load_Float(const char* Ini, const char* Section, const char* Entry)
{
	float Result;

	INIClass *Ini2 = Settings::Open_INI(Ini);
	
	Result = Ini2->Get_Float(Section, Entry, -1337.0f);
	Ini2->Shutdown();

	if (Result == -1337.0f)
	{
		Functions::Show_Fatal_Warning(TT_FORMAT(256, "Error loading variable %s from section %s in %s",
			Entry, Section, Ini));
	}
	return Result;
}

bool Settings::Load_Bool(const char* Ini, const char* Section, const char* Entry)
{
	int Result, Bool;

	INIClass *Ini2 = Settings::Open_INI(Ini);
	
	Result = Ini2->Get_Int(Section, Entry, -1337);
	Bool = Ini2->Get_Bool(Section, Entry, false);
	Ini2->Shutdown();

	if (Result == -1337)
	{
		Functions::Show_Fatal_Warning(TT_FORMAT(256, "Error loading variable %s from section %s in %s",
			Entry, Section, Ini));
	}
	return Bool;
}

INIClass* Settings::Open_INI(const char* Ini)
{
	INIClass *Ini2 = 0;
	RawFileClass file(Ini);

	if (file.Is_Available(0))
	{
		Ini2 = new INIClass(file);
	}
	
	else
	{
		Functions::Show_Fatal_Warning(TT_FORMAT(256, "Error loading file %s. File not available.", Ini));
	}

	if (!Ini2)
	{
		return 0;
	}
	return Ini2;
}

DynamicVectorClass<StringClass> Settings::Load_String_List(const char* Ini, const char* Section)
{
	INIClass* Ini2 = Settings::Open_INI(Ini);
	DynamicVectorClass<StringClass> Vector;

	int Entries = Ini2->Entry_Count(Section);

	for (int i = 0; i < Entries; i++)
	{
		const char* Entry = Ini2->Get_Entry(Section, i);
		StringClass Result;
		Result = Settings::Load_String(Ini, Section, Entry);
		Vector.Add(Result);
	}
	Ini2->Shutdown();
	return Vector;
}

void Settings::Load_Map_Rules()
{
	// Separate function as Load_String() closes the FDS if something can't be found
	INIClass* Ini = Settings::Open_INI(ABDIR "Maps.ini");
	
	Ini->Get_String(Settings::MapRules, Get_Map(Get_Current_Map_Index()), "MapRules", "ERR");
	Ini->Shutdown();

	if (MapRules == "ERR")
	{
		MapRules = "No special rules for this map.";
	}
}

void Settings::Load_Moderators()
{
	DynamicVectorClass<StringClass> Moderators;
	Moderators = Settings::Load_String_List(ABDIR "Moderators.ini", "ModeratorList");

	for (int i = 0; i < Moderators.Count(); i++)
	{
		Tokenizer Tokens(Moderators[i]);

		Moderator_t* Moderator = new Moderator_t;
		Moderator->IRCNick = Tokens[1];
		Moderator->InGameNick = Tokens[2];
		Moderator->Access = Tokens[3];
		
		Settings::ModsGameNick.Insert(Tokens[2], Moderator);
		Settings::ModsIRCNick.Insert(Tokens[1], Moderator);
	}
}